/*****************************************************************************
*  LPC43xx SCT demo
*
*  Use L counter part to toggle SCT_OUT0 every 10 msec
*****************************************************************************/
#include "nxp_lpc43xx.h"

void SCT_Init(void)
{
    LPC_SCT->CONFIG |= (1 << 17);                          // two 16-bit timers, clocked internally, auto limit
    LPC_SCT->CTRL_L |= ((SystemCoreClock/1000000-1) << 5); // set prescaler, SCT clock = 1 MHz
                                              
    LPC_SCT->MATCH[0].L     = 10000;                       // match 0 @ 10000/1MHz = 10 msec
    LPC_SCT->MATCHREL[0].L  = 10000;

    LPC_SCT->EVENT[0].STATE = 0x00000001;                  // event 0 only happens in state 0
    LPC_SCT->EVENT[0].CTRL  = (0 << 0)  |                  // MATCHSEL[3:0]   = related to match 0
                              (1 << 12) |                  // COMBMODE[13:12] = match condition only
                              (1 << 14) |                  // STATELD [14]    = STATEV is loaded into state
                              (0 << 15);                   // STATEV  [15]    = new state is 0

    LPC_SCT->OUT[0].SET = (1 << 0);                        // event 0 will set SCT_OUT0
    LPC_SCT->OUT[0].CLR = (1 << 0);                        // event 0 will clear SCT_OUT0
    LPC_SCT->RES        = (3 << 0);                        // output 0 toggles on conflict

    LPC_SCT->CTRL_L    &= ~(1 << 2);                       // unhalt it by clearing bit 2 of the CTRL register
}
